#include "gdma_glue.h"
#include "rtl_types.h"
#include "contentGen.h"
#define UNCACHED_ADDRESS(x) ((void *)(0x20000000 | (uint32)x ))
#define PHYSICAL_ADDRESS(x) (((uint32)x) & 0x1fffffff)


int isRedundantLocation(uint32 location, uint32* locationArry, uint32 arraySize);

/******************************************************************************
 * Generate test case content for single pattern match
 * Return vlaue: A pointer points to the location of the generated content
 * contentSize : The requested number of bytes of the generated content.
 * occurTimes  : The number of times that pattern occurs.
 * pattern     : A pointer of the pattern used for pattern matching.
 * retLocations: A pointer which points to the location array of occurences.
 *
 * retLocations is also a generated by this function.
 * ***************************************************************************/
int contentGen(char* cachedContent, uint32 contentSize, uint32 occurTimes, char* pattern, uint32** retLocations, int isContentAlphabet)
{
	char* content;
	char lastChar;
	char randomChar;
	uint32 patternLength;
	uint32 location;
	uint32 numOfSlot;
	uint32 locationIndex;	
	uint32 temp;
	uint32 i;

	patternLength = strlen(pattern);
	numOfSlot = contentSize/patternLength;
	if(numOfSlot>1){
		numOfSlot--;
	}
	if(numOfSlot < occurTimes)
		return 0;
	content = NULL;
	/* Allocate space for content.*/
#ifdef RTL865X_MODEL_KERNEL
	content = UNCACHED_ADDRESS(cachedContent);
#else
	content = cachedContent;
#endif
	/* Get the last charactor of the pattern.*/
	lastChar = pattern[patternLength-1];

	/*Assign charactors except last charactor of the pattern to each location of the content.*/
	location = 0;
	while(location<contentSize){
		if(isContentAlphabet){
			randomChar = 'a'+ rtlglue_random()%26;
		}
		else{
			randomChar = rtlglue_random()%256;	
		}
		content[location] = randomChar;
		location++;
	}

	locationIndex = 0;	
	/*Produce the occurences.*/
	(*retLocations) = (uint32*)rtlglue_malloc(256*sizeof(uint32));
	if((*retLocations)==NULL)
		rtlglue_printf("*retLocation = NULL, numOfSlot = %u\n",numOfSlot);

	while(locationIndex<occurTimes){
		location = rtlglue_random()%numOfSlot;
		if(isRedundantLocation((location+1)*patternLength, *retLocations, locationIndex)==0){
			strncpy((char*)(content+location*patternLength),pattern, patternLength);
			for(i=0;i<locationIndex;i++){
				if(((*retLocations)[i]/patternLength)-1 > location){
					temp =  (*retLocations)[i]/patternLength - 1; 
					(*retLocations)[i] = (location+1)*patternLength;
					location = temp;
				}
			}
			(*retLocations)[locationIndex++] = (location+1)*patternLength;
		}
	}

	return 1;

}
int isRedundantLocation(uint32 location, uint32* locationArray, uint32 arraySize)
{
	int i;

	for(i=0;i<arraySize;i++){
		if(locationArray[i] == location){
			return 1;
		}	
	}
	
	return 0;	
}
